﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace Chapter_17
{
    class Program
    {
        static void Main()
        {
            DemoListOfString();
            DemoArrayList();
            DemoListOfCustomer();
            DemoArrayListBoxingPenalty();
            DemoListAvoidingBoxingPenalty();
            DemoShapeList();
            DemoGenericSingleLinkedList();
            DemoGenericInterface();
            DemoGenericDelegate();
            DemoConstraints();

            Console.ReadKey();
        }

        private static void DemoListOfString()
        {
            var letters = new List<string>();

            letters.Add("Anna");
            letters.Add("Barbara");
            letters.Add("Cezary");

            foreach (var letter in letters)
            {
                Console.WriteLine(letter);
            }
        }

        private static void DemoArrayList()
        {
            ArrayList customers = new ArrayList();

            customers.Add(new Customer());
            //customers.Add(new Employee());
            //customers.Add(15.5f);

            foreach (Customer cust in customers)
            {
                Console.WriteLine(cust.ToString());
            }
        }

        private static void DemoListOfCustomer()
        {
            List<Customer> customers = new List<Customer>();

            customers.Add(new Customer());
            customers.Add(new Customer());
            //customers.Add(new Employee());

            foreach (Customer cust in customers)
            {
                Console.WriteLine(cust.ToString());
            }
        }

        private static void DemoArrayListBoxingPenalty()
        {
            ArrayList myInts = new ArrayList();

            myInts.Add(1);
            myInts.Add(2);
            myInts.Add(3);

            foreach (int myInt in myInts)
            {
                Console.WriteLine(myInt);
            }
        }

        private static void DemoListAvoidingBoxingPenalty()
        {
            List<int> myInts = new List<int>();

            myInts.Add(1);
            myInts.Add(2);
            myInts.Add(3);

            foreach (int myInt in myInts)
            {
                Console.WriteLine(myInt);
            }
        }

        private static void DemoShapeList()
        {
            List<Shape> myShapes = new List<Shape>();

            // ponieważ obiekty Box i Circle są typu Shape,
            //	mogą również zostać dodane do kolekcji
            myShapes.Add(new Shape());
            myShapes.Add(new Box());
            myShapes.Add(new Circle());

            // Pole Name jest odczytywane w sposób polimorficzny
            foreach (Shape shape in myShapes)
            {
                Console.WriteLine(shape.Name);
            }
        }

        static void DemoGenericSingleLinkedList()
        {
            // tworzy instancję mojego własnego typu szablonowego -
            // jest to kolekcja łańcuchów
            GenericSingleLinkedList<string> singleLL = new GenericSingleLinkedList<string>();

            //
            // przetestuj kolekcję, by sprawdzić, czy działa
            //

            singleLL.Insert(0, "zero");
            singleLL.Insert(1, "jeden");
            singleLL.Insert(2, "dwa");
            singleLL.Insert(3, "trzy");

            singleLL.Insert(2, "wstawiono");

            singleLL.RemoveAt(0);
            singleLL.RemoveAt(3);

            singleLL.Remove("wstawiono");

            // po modyfikacji użyj innych metod,
            // aby sprawdzić status kolekcji
            Console.WriteLine("Zawiera element 'dwa'?:   {0}", singleLL.Contains("dwa"));
            Console.WriteLine("Zawiera element 'trzy'?: {0}", singleLL.Contains("trzy"));
            Console.WriteLine("IndexOf 'dwa':     {0}", singleLL.IndexOf("dwa"));

            // kopiuj listę
            string[] myStrings = new string[singleLL.Count];
            singleLL.CopyTo(myStrings, 0);

            Console.WriteLine("Wyświetlanie zawartości tablicy po wywołaniu CopyTo.");

            // iteruj elementy listy, aby sprawdzić, że kopiowanie działa poprawnie
            foreach (string name in myStrings)
            {
                Console.WriteLine(name);
            }

            // użyj metody Add, aby także sprawdzić, czy działa poprawnie
            singleLL.Add("cztery");

            // sprawdź indeksator
            Console.WriteLine("Wartość elementu singleLL[1]: {0}", singleLL[1]);

            // upewnij się, że kolekcja przechowuje wartości zgodnie z naszymi oczekiwaniami
            Console.WriteLine("Wyświetlanie zawartości singleLL.");
            foreach (string name in singleLL)
            {
                Console.WriteLine(name);
            }

            // sprawdź, że metoda Clear działa prawidłowo
            singleLL.Clear();
            Console.WriteLine("Rozmiar singleLL: {0}", singleLL.Count);
        }

        private static void DemoGenericInterface()
        {
            Person cust1 = new Person();
            Person cust2 = new Person();

            cust1.Name = "Józef";
            cust2.Name = "Józef";

            Console.WriteLine(cust1.Equals(cust2));
        }

        private static void DemoGenericDelegate()
        {
            Clock clock = new Clock();
            Alarm alarm = new Alarm();

            clock.Tick += alarm.ListenToTick;

            clock.RaiseTick();
        }

        private static void DemoConstraints()
        {
            string headerFormat = @"
***************************************
*                                     
* {0}
*
***************************************
";

            ConstraintDemo constraints = new ConstraintDemo();

            Console.WriteLine(headerFormat, "Test ograniczeń interfejsu");

            // zaprezentuj działanie ograniczeń interfejsu
            constraints.TestInterfaceConstraints();

            Console.WriteLine(headerFormat, "Test ograniczeń klasy bazowej");

            // zaprezentuj działanie ograniczeń klasy bazowej
            constraints.TestBaseClassConstraints();

            Console.WriteLine(headerFormat, "Test ograniczeń typu referencyjnego i wartościowego");

            // zaprezentuj działanie ograniczeń typu referencyjnego
            // i wartościowego
            constraints.TestReferenceAndValueTypeConstraints();

            Console.WriteLine(headerFormat, "Test ograniczeń konstruktora");

            // zaprezentuj działanie ograniczeń konstruktora
            constraints.TestConstructorConstraints();

            Console.WriteLine(headerFormat, "Test ograniczeń dotyczących klas");

            //
            // uruchom prezentację działania ograniczeń typu szablonowego
            //

            CustomerProcessor<Customer, Order> custProc =
                new CustomerProcessor<Customer, Order>();

            LargBiz largeCust = new LargBiz();
            MailOrder mailOrd = new MailOrder();

            custProc.ProcessOrder(largeCust, mailOrd);
        }
    }
}
